<?php
include '../../koneksi.php';

$tanggal = $_GET['tanggal'] ?? '';
$limit   = $_GET['limit']   ?? 10;
$search  = $_GET['search']  ?? '';

$where = "WHERE 1=1";

if ($tanggal != '') {
    $where .= " AND ag.tanggal = '$tanggal'";
}
if ($search != '') {
    $where .= " AND (g.nama_lengkap LIKE '%$search%' OR g.nip LIKE '%$search%')";
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Absensi Guru</title>

<link href="../../bootstrap-5.3.8-dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">

<style>
body {
    background:#f4f6f9;
}
.card {
    border-radius: 18px;
    box-shadow: 0 12px 35px rgba(0,0,0,.12);
}
.filter-bar {
    position: sticky;
    top: 0;
    z-index: 10;
    background: #fff;
    padding: 15px;
    border-radius: 12px;
    box-shadow: 0 6px 15px rgba(0,0,0,.08);
}
.table-wrapper {
    max-height: 55vh;
    overflow-y: auto;
}
.table thead {
    position: sticky;
    top: 0;
    z-index: 5;
    background: linear-gradient(90deg,#1e6f91,#2a8fbd);
    color: #fff;
}
.table-hover tbody tr:hover {
    background-color: rgba(13,202,240,.08);
    transition: .3s;
}
.badge-status {
    padding: 6px 12px;
    border-radius: 20px;
    font-weight: 500;
}
</style>
</head>

<body>

<div class="container-fluid mt-3">
<div class="card p-4">

<!-- HEADER -->
<div class="d-flex justify-content-between align-items-center mb-3">
  <h4 class="fw-bold mb-0">
    <i class="bi bi-person-check"></i> Data Absensi Guru
  </h4>
</div>

<!-- FILTER -->
<form method="get" class="filter-bar mb-3">
<div class="row g-2 align-items-end">

  <div class="col-md-3">
    <label class="form-label">Tanggal</label>
    <input type="date" name="tanggal" value="<?= $tanggal ?>" class="form-control">
  </div>

  <div class="col-md-3">
    <label class="form-label">Cari Guru</label>
    <input type="text" name="search" value="<?= $search ?>" class="form-control"
      placeholder="Nama / NIP">
  </div>

  <div class="col-md-2">
    <label class="form-label">Tampilkan</label>
    <select name="limit" class="form-select">
      <?php foreach ([10,25,50,100] as $l): ?>
        <option value="<?= $l ?>" <?= $limit==$l?'selected':'' ?>><?= $l ?></option>
      <?php endforeach; ?>
    </select>
  </div>

  <div class="col-md-4">
    <button class="btn btn-info text-white rounded-pill px-4">
      <i class="bi bi-funnel"></i> Filter
    </button>
    <a href="absen_guru.php" class="btn btn-secondary rounded-pill px-4">
      Reset
    </a>
  </div>

</div>
</form>

<!-- TABLE -->
<div class="table-wrapper">
<table class="table table-hover align-middle">
<thead>
<tr>
  <th>No</th>
  <th>NIP</th>
  <th>Nama Guru</th>
  <th>Tanggal</th>
  <th>Masuk</th>
  <th>Pulang</th>
  <th>Status</th>
</tr>
</thead>
<tbody>

<?php
$no = 1;

$query = "
SELECT ag.*, g.nip, g.nama_lengkap
FROM absensi_guru ag
JOIN guru g ON ag.guru_id = g.id
$where
ORDER BY ag.tanggal DESC, ag.jam_masuk DESC
LIMIT $limit
";

$result = mysqli_query($koneksi, $query);

if ($result && mysqli_num_rows($result) > 0) {
  while ($d = mysqli_fetch_assoc($result)) {

    $statusClass = match($d['status']) {
      'Hadir' => 'bg-success',
      'Izin'  => 'bg-warning text-dark',
      'Sakit' => 'bg-info',
      default => 'bg-secondary'
    };

    echo "
    <tr>
      <td>{$no}</td>
      <td>{$d['nip']}</td>
      <td>{$d['nama_lengkap']}</td>
      <td>{$d['tanggal']}</td>
      <td>{$d['jam_masuk']}</td>
      <td>".($d['jam_pulang'] ?: '-')."</td>
      <td><span class='badge badge-status {$statusClass}'>{$d['status']}</span></td>
    </tr>";
    $no++;
  }
} else {
  echo "<tr><td colspan='7' class='text-center text-muted'>Data tidak ditemukan</td></tr>";
}
?>

</tbody>
</table>
</div>

</div>
</div>

<script src="../../bootstrap-5.3.8-dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
