<?php
session_start();
include '../koneksi.php';

if (!isset($_SESSION['username']) || $_SESSION['role'] != 'admin') {
    header("Location: login.php");
    exit;
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Dashboard Admin | MAYABSEN</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<link href="../bootstrap-5.3.8-dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">

<style>
* { font-family: 'Poppins', sans-serif; }

body {
    background: linear-gradient(135deg, #eaf2f8, #fdfefe);
    height: 100vh;
    overflow: hidden;
}

/* ===== SIDEBAR ===== */
.sidebar {
    width: 260px;
    background: linear-gradient(180deg, #1e6f91, #144c66);
    color: #fff;
    position: fixed;
    height: 100%;
    display: flex;
    flex-direction: column;
    box-shadow: 4px 0 20px rgba(0,0,0,.15);
}

.sidebar-brand {
    padding: 25px 20px;
    text-align: center;
    font-size: 22px;
    font-weight: 700;
    border-bottom: 1px solid rgba(255,255,255,.15);
}

.sidebar-section {
    padding: 12px 20px 6px;
    font-size: 11px;
    text-transform: uppercase;
    opacity: .75;
}

.sidebar a {
    color: #fff;
    text-decoration: none;
    padding: 13px 22px;
    display: flex;
    align-items: center;
    gap: 12px;
    transition: .3s;
    border-left: 4px solid transparent;
}

.sidebar a:hover,
.sidebar a.active {
    background: rgba(255,255,255,.12);
    border-left: 4px solid #0dcaf0;
}

.sidebar a i {
    font-size: 18px;
}

/* ===== CONTENT ===== */
.main-content {
    margin-left: 260px;
    height: 100vh;
    display: flex;
    flex-direction: column;
    padding: 20px;
}

/* ===== TOPBAR ===== */
.topbar {
    background: #fff;
    border-radius: 15px;
    padding: 15px 25px;
    display: flex;
    justify-content: space-between;
    align-items: center;
    box-shadow: 0 6px 20px rgba(0,0,0,.08);
    margin-bottom: 18px;
}

.topbar h5 {
    margin: 0;
    font-weight: 600;
}

.topbar-right {
    display: flex;
    align-items: center;
    gap: 18px;
}

.clock {
    font-size: 13px;
    color: #555;
    text-align: right;
}

.logout-btn {
    width: 42px;
    height: 42px;
    border-radius: 50%;
    border: none;
    background: #ff6b81;
    color: #fff;
    font-size: 20px;
    display: flex;
    align-items: center;
    justify-content: center;
    transition: .3s;
}

.logout-btn:hover {
    background: #ff4757;
}

/* ===== IFRAME ===== */
.content-frame {
    flex: 1;
    background: #fff;
    border-radius: 18px;
    overflow: hidden;
    box-shadow: 0 8px 30px rgba(0,0,0,.12);
}

iframe {
    width: 100%;
    height: 100%;
    border: none;
}
</style>
</head>

<body>

<!-- SIDEBAR -->
<div class="sidebar">
    <div class="sidebar-brand">
        <i class="bi bi-fingerprint"></i> MAYABSEN
    </div>

    <!-- DEFAULT ACTIVE -->
    <a href="#" class="menu active" data-page="dashboard_home.php">
        <i class="bi bi-speedometer2"></i> Dashboard
    </a>

    <div class="sidebar-section">Akademik</div>
    <a href="#" class="menu" data-page="kelola_absen/absen.php">
        <i class="bi bi-calendar-check"></i> Absen Siswa
    </a>
    <a href="#" class="menu" data-page="absen_guru/absen_guru.php">
        <i class="bi bi-calendar-check"></i> Absen Guru
    </a>
    <a href="#" class="menu" data-page="kelola_jadwal/jadwal.php">
        <i class="bi bi-clock-history"></i> Kelola Jadwal
    </a>

    <div class="sidebar-section">Data Master</div>
    <a href="#" class="menu" data-page="kelola_guru/guru.php">
        <i class="bi bi-building"></i> Kelola Guru
    </a>
    <a href="#" class="menu" data-page="kelola_siswa/siswa.php">
        <i class="bi bi-people"></i> Kelola Siswa
    </a>
    <a href="#" class="menu" data-page="kelola_form/form.php">
        <i class="bi bi-ui-checks"></i> Kelola Form
    </a>

    <div class="sidebar-section">Laporan</div>
    <a href="#" class="menu" data-page="laporan/laporan.php">
        <i class="bi bi-file-earmark-text"></i> Laporan
    </a>
</div>

<!-- MAIN -->
<div class="main-content">

    <!-- TOPBAR -->
    <div class="topbar">
        <div>
            <h5>Selamat Datang, <?= htmlspecialchars($_SESSION['username']); ?> 👋</h5>
            <small class="text-muted">Dashboard Administrator</small>
        </div>

        <div class="topbar-right">
            <div class="clock" id="clock"></div>
            <a href="logout.php" class="logout-btn" title="Logout">
                😺
            </a>
        </div>
    </div>

    <!-- CONTENT -->
    <div class="content-frame">
        <!-- DEFAULT DASHBOARD -->
        <iframe id="iframeContent" src="dashboard_home.php"></iframe>
    </div>

</div>

<script src="../bootstrap-5.3.8-dist/js/bootstrap.bundle.min.js"></script>

<script>
/* MENU ACTIVE + LOAD IFRAME */
const menuLinks = document.querySelectorAll('.menu');
const iframe = document.getElementById('iframeContent');

menuLinks.forEach(link => {
    link.addEventListener('click', e => {
        e.preventDefault();
        iframe.src = link.dataset.page;

        menuLinks.forEach(m => m.classList.remove('active'));
        link.classList.add('active');
    });
});

/* JAM & HARI REALTIME */
function updateClock() {
    const now = new Date();
    const hari = now.toLocaleDateString('id-ID', { weekday: 'long' });
    const tanggal = now.toLocaleDateString('id-ID', { day:'2-digit', month:'long', year:'numeric' });
    const jam = now.toLocaleTimeString('id-ID');

    document.getElementById('clock').innerHTML =
        `${hari}<br>${tanggal}<br>${jam}`;
}

setInterval(updateClock, 1000);
updateClock();
</script>

</body>
</html>
