<?php
include '../koneksi.php';

/* ===== AMANKAN NAMA KONEKSI ===== */
if (isset($conn)) {
    $db = $conn;
} elseif (isset($koneksi)) {
    $db = $koneksi;
} else {
    die("Koneksi database tidak ditemukan!");
}

/* ===== HITUNG DATA ===== */
$siswa = mysqli_fetch_assoc(mysqli_query($db, "SELECT COUNT(*) total FROM siswa"))['total'];
$guru  = mysqli_fetch_assoc(mysqli_query($db, "SELECT COUNT(*) total FROM guru"))['total'];

$total_absen = mysqli_fetch_assoc(mysqli_query($db, "SELECT COUNT(*) total FROM absensi"))['total'];
$hadir = mysqli_fetch_assoc(mysqli_query($db, "SELECT COUNT(*) total FROM absensi WHERE status='Hadir'"))['total'];

$persentase = $total_absen > 0 ? round(($hadir / $total_absen) * 100, 2) : 0;

/* ===== DATA GRAFIK PER HARI ===== */
$qGrafik = mysqli_query($db, "
    SELECT 
        DAYNAME(tanggal) hari,
        COUNT(*) jumlah
    FROM absensi
    WHERE status='Hadir'
    GROUP BY tanggal
    ORDER BY tanggal ASC
    LIMIT 7
");

$hari = [];
$jumlah = [];
while ($row = mysqli_fetch_assoc($qGrafik)) {
    $hari[] = $row['hari'];
    $jumlah[] = $row['jumlah'];
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Dashboard Admin</title>
<link href="../bootstrap-5.3.8-dist/css/bootstrap.min.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

<style>
body {
    background: #f4f6f9;
}
.stat-card {
    border-radius: 16px;
    padding: 25px;
    color: #fff;
}
.bg-siswa { background: linear-gradient(135deg,#0d6efd,#6ea8fe); }
.bg-guru  { background: linear-gradient(135deg,#198754,#75b798); }
.bg-absen { background: linear-gradient(135deg,#fd7e14,#ffb370); }
</style>
</head>

<body class="p-4">

<h4 class="mb-4 fw-semibold">📊 Dashboard Statistik</h4>

<div class="row g-4 mb-4">
    <div class="col-md-4">
        <div class="stat-card bg-siswa shadow">
            <h6>Total Siswa</h6>
            <h2><?= $siswa ?></h2>
        </div>
    </div>
    <div class="col-md-4">
        <div class="stat-card bg-guru shadow">
            <h6>Total Guru</h6>
            <h2><?= $guru ?></h2>
        </div>
    </div>
    <div class="col-md-4">
        <div class="stat-card bg-absen shadow">
            <h6>Persentase Kehadiran</h6>
            <h2><?= $persentase ?>%</h2>
        </div>
    </div>
</div>

<div class="card shadow border-0 rounded-4 p-4">
    <h6 class="mb-3 fw-semibold">Grafik Kehadiran Siswa</h6>
    <canvas id="grafikAbsen"></canvas>
</div>

<script>
new Chart(document.getElementById('grafikAbsen'), {
    type: 'line',
    data: {
        labels: <?= json_encode($hari) ?>,
        datasets: [{
            label: 'Jumlah Hadir',
            data: <?= json_encode($jumlah) ?>,
            borderWidth: 3,
            borderColor: '#0d6efd',
            backgroundColor: 'rgba(13,110,253,.15)',
            tension: .4,
            fill: true,
            pointRadius: 4
        }]
    },
    options: {
        responsive: true,
        plugins: {
            legend: { display: false }
        }
    }
});
</script>

</body>
</html>
