<?php
include '../../koneksi.php';

$kelas   = $_GET['kelas']   ?? '';
$tanggal = $_GET['tanggal'] ?? '';
$limit   = $_GET['limit']   ?? 10;
$search  = $_GET['search']  ?? '';

$where = "WHERE 1=1";

if ($kelas != '') {
    $where .= " AND siswa.kelas = '$kelas'";
}
if ($tanggal != '') {
    $where .= " AND absensi.tanggal = '$tanggal'";
}
if ($search != '') {
    $where .= " AND (siswa.nama_lengkap LIKE '%$search%' OR siswa.nisn LIKE '%$search%')";
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Kelola Absensi</title>

<link href="../../bootstrap-5.3.8-dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">

<style>
body {
    background:#f4f6f9;
}
.card {
    border-radius: 18px;
    box-shadow: 0 12px 35px rgba(0,0,0,.12);
}
.filter-bar {
    position: sticky;
    top: 0;
    z-index: 10;
    background: #fff;
    padding: 15px;
    border-radius: 12px;
    box-shadow: 0 6px 15px rgba(0,0,0,.08);
}
.table-wrapper {
    max-height: 55vh;
    overflow-y: auto;
}
.table thead {
    position: sticky;
    top: 0;
    z-index: 5;
    background: linear-gradient(90deg,#1e6f91,#2a8fbd);
    color: #fff;
}
.table-hover tbody tr:hover {
    background-color: rgba(13,202,240,.08);
    transition: .3s;
}
.badge-status {
    padding: 6px 12px;
    border-radius: 20px;
    font-weight: 500;
}
</style>
</head>

<body>

<div class="container-fluid mt-3">
<div class="card p-4">

<!-- HEADER -->
<div class="d-flex justify-content-between align-items-center mb-3">
  <h4 class="fw-bold mb-0">
    <i class="bi bi-calendar-check"></i> Data Absensi
  </h4>
  <button class="btn btn-primary rounded-pill"
    onclick="openInParent('kelola_absen/tambah.php')">
    <i class="bi bi-plus-circle"></i> Tambah Absen
  </button>
</div>

<!-- FILTER -->
<form method="get" class="filter-bar mb-3">
<div class="row g-2 align-items-end">

  <div class="col-md-2">
    <label class="form-label">Kelas</label>
    <select name="kelas" class="form-select">
      <option value="">Semua</option>
      <?php
      $kelasList = ['X IPA','X IPS','XI IPA','XI IPS','XII IPA','XII IPS'];
      foreach ($kelasList as $k) {
        $sel = ($kelas==$k)?'selected':'';
        echo "<option $sel>$k</option>";
      }
      ?>
    </select>
  </div>

  <div class="col-md-2">
    <label class="form-label">Tanggal</label>
    <input type="date" name="tanggal" value="<?= $tanggal ?>" class="form-control">
  </div>

  <div class="col-md-2">
    <label class="form-label">Tampilkan</label>
    <select name="limit" class="form-select">
      <?php foreach ([10,25,50,100] as $l): ?>
        <option value="<?= $l ?>" <?= $limit==$l?'selected':'' ?>><?= $l ?></option>
      <?php endforeach; ?>
    </select>
  </div>

  <div class="col-md-3">
    <label class="form-label">Cari</label>
    <input type="text" name="search" value="<?= $search ?>" class="form-control"
      placeholder="Nama / NISN">
  </div>

  <div class="col-md-3">
    <button class="btn btn-info text-white rounded-pill px-4">
      <i class="bi bi-funnel"></i> Filter
    </button>
    <a href="absen.php" class="btn btn-secondary rounded-pill px-4">
      Reset
    </a>
  </div>

</div>
</form>

<!-- TABLE -->
<div class="table-wrapper">
<table class="table table-hover align-middle">
<thead>
<tr>
  <th>No</th>
  <th>NISN</th>
  <th>Nama</th>
  <th>Kelas</th>
  <th>Tanggal</th>
  <th>Masuk</th>
  <th>Pulang</th>
  <th>Status</th>
  <th class="text-center">Aksi</th>
</tr>
</thead>
<tbody>

<?php
$no = 1;
$query = "
SELECT absensi.*, siswa.nisn, siswa.nama_lengkap, siswa.kelas
FROM absensi
JOIN siswa ON absensi.user_id = siswa.user_id
$where
ORDER BY absensi.tanggal DESC, absensi.jam_masuk DESC
LIMIT $limit
";

$result = mysqli_query($koneksi, $query);

if ($result && mysqli_num_rows($result) > 0) {
  while ($d = mysqli_fetch_assoc($result)) {

    $statusClass = match($d['status']) {
      'Hadir' => 'bg-success',
      'Izin'  => 'bg-warning text-dark',
      'Sakit' => 'bg-info',
      default => 'bg-secondary'
    };

    echo "
    <tr>
      <td>{$no}</td>
      <td>{$d['nisn']}</td>
      <td>{$d['nama_lengkap']}</td>
      <td><span class='badge bg-primary'>{$d['kelas']}</span></td>
      <td>{$d['tanggal']}</td>
      <td>{$d['jam_masuk']}</td>
      <td>".($d['jam_pulang'] ?: '-')."</td>
      <td><span class='badge badge-status {$statusClass}'>{$d['status']}</span></td>
      <td class='text-center'>
        <button class='btn btn-warning btn-sm rounded-pill'
          onclick=\"openInParent('kelola_absen/edit.php?id={$d['id']}')\">
          <i class='bi bi-pencil'></i>
        </button>
        <button class='btn btn-danger btn-sm rounded-pill'
          onclick=\"hapusAbsen({$d['id']})\">
          <i class='bi bi-trash'></i>
        </button>
      </td>
    </tr>";
    $no++;
  }
} else {
  echo "<tr><td colspan='9' class='text-center text-muted'>Data tidak ditemukan</td></tr>";
}
?>

</tbody>
</table>
</div>

</div>
</div>

<script src="../../bootstrap-5.3.8-dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
function openInParent(path) {
  try {
    parent.document.getElementById('iframeContent').src = path;
  } catch {
    window.location.href = path;
  }
}

function hapusAbsen(id) {
  Swal.fire({
    title: 'Hapus Data?',
    text: 'Data tidak bisa dikembalikan!',
    icon: 'warning',
    showCancelButton: true,
    confirmButtonColor: '#dc3545',
    cancelButtonColor: '#0d6efd',
    confirmButtonText: 'Ya, hapus'
  }).then((res) => {
    if (res.isConfirmed) {
      fetch('hapus.php?id=' + id)
      .then(() => location.reload());
    }
  });
}
</script>

</body>
</html>
