<?php
include '../../koneksi.php';

if (!isset($_GET['id'])) {
  die("ID tidak ditemukan");
}

$id = $_GET['id'];

$q = mysqli_query($koneksi, "
SELECT 
  f.*,
  u.role,
  s.nama_lengkap AS nama_siswa,
  s.nisn,
  s.kelas,
  g.nama_lengkap AS nama_guru,
  g.nip
FROM form_izin f
JOIN users u ON f.user_id = u.id
LEFT JOIN siswa s ON u.id = s.user_id
LEFT JOIN guru g ON u.id = g.id
WHERE f.id = '$id'
");

$data = mysqli_fetch_assoc($q);
if (!$data) die("Data tidak ditemukan");

$success = false;

if (isset($_POST['simpan'])) {
  $status = $_POST['status'];

  mysqli_query($koneksi, "
    UPDATE form_izin SET status='$status'
    WHERE id='$id'
  ");

  $success = true;
}

/* PENENTU DATA */
$nama = ($data['role']=='siswa') ? $data['nama_siswa'] : $data['nama_guru'];
$identitas = ($data['role']=='siswa') ? $data['nisn'] : $data['nip'];
$kelasView = ($data['role']=='siswa')
  ? "<span class='badge bg-primary'>{$data['kelas']}</span>"
  : "<span class='badge bg-dark'>Guru</span>";
?>

<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Kelola Form Izin</title>

<link href="../../bootstrap-5.3.8-dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<style>
body { background:#f4f6f9; }
.card {
  border-radius:18px;
  box-shadow:0 12px 35px rgba(0,0,0,.12);
}
.label {
  font-weight:600;
  color:#555;
}
.preview-box {
  border:1px solid #ddd;
  border-radius:12px;
  padding:10px;
  background:#fff;
}
</style>
</head>

<body>

<div class="container-fluid mt-3">
<div class="card p-4">

<h4 class="fw-bold mb-4">
  <i class="bi bi-gear"></i> Kelola Pengajuan Izin
</h4>

<div class="row mb-3">
  <div class="col-md-6">
    <p><span class="label">Nama</span><br><?= htmlspecialchars($nama) ?></p>
    <p><span class="label">Identitas</span><br><?= htmlspecialchars($identitas) ?></p>
    <p><span class="label">Kelas</span><br><?= $kelasView ?></p>
  </div>

  <div class="col-md-6">
    <p><span class="label">Tanggal</span><br><?= $data['tanggal'] ?></p>
    <p><span class="label">Jenis</span><br><?= $data['jenis'] ?></p>
    <p><span class="label">Keterangan</span><br><?= $data['keterangan'] ?></p>
  </div>
</div>

<!-- PREVIEW FILE -->
<p class="label mb-2">Surat</p>

<div class="preview-box mb-4">
<?php
if (!empty($data['file_surat'])) {
  $ext = strtolower(pathinfo($data['file_surat'], PATHINFO_EXTENSION));

  if (in_array($ext, ['jpg','jpeg','png'])) {
    echo "<img src='../../uploads/{$data['file_surat']}' class='img-fluid rounded'>";
  } else {
    echo "<iframe src='../../uploads/{$data['file_surat']}' width='100%' height='400'></iframe>";
  }
} else {
  echo "<span class='text-muted'>Tidak ada file</span>";
}
?>
</div>

<form method="POST">
  <label class="label mb-1">Status</label>
  <select name="status" class="form-select mb-4">
    <?php foreach (['Menunggu','Disetujui','Ditolak'] as $s): ?>
      <option value="<?= $s ?>" <?= $data['status']==$s?'selected':'' ?>>
        <?= $s ?>
      </option>
    <?php endforeach; ?>
  </select>

  <div class="d-flex gap-2">
    <button name="simpan" class="btn btn-success rounded-pill px-4">
      <i class="bi bi-check-circle"></i> Simpan
    </button>

    <button type="button" onclick="kembali()"
      class="btn btn-secondary rounded-pill px-4">
      Kembali
    </button>
  </div>
</form>

</div>
</div>

<?php if ($success): ?>
<script>
Swal.fire({
  icon: 'success',
  title: 'Berhasil',
  text: 'Status izin berhasil diperbarui',
  timer: 1500,
  showConfirmButton: false
}).then(() => {
  try {
    parent.document.getElementById('iframeContent').src = 'kelola_form/form.php';
  } catch {
    window.location.href = 'form.php';
  }
});
</script>
<?php endif; ?>

<script>
function kembali() {
  try {
    parent.document.getElementById('iframeContent').src = 'kelola_form/form.php';
  } catch {
    window.location.href = 'form.php';
  }
}
</script>

</body>
</html>
