<?php
include '../../koneksi.php';

$mapel  = $_GET['mapel'] ?? '';
$status = $_GET['status'] ?? '';
$search = $_GET['search'] ?? '';
$limit  = $_GET['limit'] ?? 10;

$where = "WHERE 1=1";

if ($mapel != '') {
  $where .= " AND mapel='$mapel'";
}

if ($status != '') {
  $where .= " AND status='$status'";
}

if ($search != '') {
  $where .= " AND (nama_lengkap LIKE '%$search%' OR nip LIKE '%$search%')";
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Kelola Guru</title>

<link href="../../bootstrap-5.3.8-dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<style>
body { background:#f4f6f9; }
.card {
  border-radius:18px;
  box-shadow:0 12px 35px rgba(0,0,0,.12);
}
.filter-bar {
  position: sticky;
  top: 0;
  z-index: 10;
  background: #fff;
  padding: 15px;
  border-radius: 12px;
  box-shadow: 0 6px 15px rgba(0,0,0,.08);
}
.table-wrapper {
  max-height:60vh;
  overflow-y:auto;
}
.table thead {
  position:sticky;
  top:0;
  background:linear-gradient(90deg,#6f42c1,#8e5de8);
  color:#fff;
}
.table-hover tbody tr:hover {
  background:rgba(111,66,193,.08);
  transition:.3s;
}
</style>
</head>

<body>

<div class="container-fluid mt-3">
<div class="card p-4">

<!-- HEADER -->
<div class="d-flex justify-content-between align-items-center mb-3">
  <h4 class="fw-bold mb-0">
    <i class="bi bi-person-badge-fill"></i> Data Guru
  </h4>

  <button class="btn btn-primary rounded-pill"
    onclick="openInParent('kelola_guru/tambah.php')">
    <i class="bi bi-plus-circle"></i> Tambah Guru
  </button>
</div>

<!-- FILTER -->
<form method="get" class="filter-bar mb-3">
<div class="row g-2 align-items-end">

  <div class="col-md-3">
    <label class="form-label">Mapel</label>
    <input type="text" name="mapel" value="<?= $mapel ?>"
      class="form-control" placeholder="Matematika / PAI">
  </div>

  <div class="col-md-2">
    <label class="form-label">Status</label>
    <select name="status" class="form-select">
      <option value="">Semua</option>
      <option <?= $status=='Aktif'?'selected':'' ?>>Aktif</option>
      <option <?= $status=='Nonaktif'?'selected':'' ?>>Nonaktif</option>
    </select>
  </div>

  <div class="col-md-3">
    <label class="form-label">Cari</label>
    <input type="text" name="search" value="<?= $search ?>"
      class="form-control" placeholder="Nama / NIP">
  </div>

  <div class="col-md-2">
    <label class="form-label">Limit</label>
    <select name="limit" class="form-select">
      <?php foreach([10,25,50,100] as $l): ?>
        <option value="<?= $l ?>" <?= $limit==$l?'selected':'' ?>><?= $l ?></option>
      <?php endforeach; ?>
    </select>
  </div>

  <div class="col-md-2 d-flex gap-2">
    <button class="btn btn-info text-white rounded-pill w-100">
      <i class="bi bi-funnel"></i>
    </button>
    <a href="guru.php" class="btn btn-secondary rounded-pill w-100">
      Reset
    </a>
  </div>

</div>
</form>

<!-- TABLE -->
<div class="table-wrapper">
<table class="table table-hover align-middle">
<thead>
<tr>
  <th>No</th>
  <th>NIP</th>
  <th>Nama</th>
  <th>Mapel</th>
  <th>Jabatan</th>
  <th>No. WA</th>
  <th>Status</th>
  <th class="text-center">Aksi</th>
</tr>
</thead>
<tbody>

<?php
$no = 1;
$q = mysqli_query($koneksi,"
  SELECT * FROM guru
  $where
  ORDER BY nama_lengkap ASC
  LIMIT $limit
");

if ($q && mysqli_num_rows($q) > 0) {
  while ($d = mysqli_fetch_assoc($q)) {
    echo "
    <tr>
      <td>{$no}</td>
      <td>{$d['nip']}</td>
      <td>{$d['nama_lengkap']}</td>
      <td>{$d['mapel']}</td>
      <td>{$d['jabatan']}</td>
      <td>{$d['no_wa']}</td>
      <td>
        <span class='badge ".($d['status']=='Aktif'?'bg-success':'bg-secondary')."'>
          {$d['status']}
        </span>
      </td>
      <td class='text-center'>
        <div class='d-flex justify-content-center gap-1'>
          
          <button class='btn btn-info btn-sm rounded-pill'
            title='Lihat Absensi'
            onclick=\"openInParent('kelola_guru/absen.php?guru_id={$d['id']}')\">
            <i class='bi bi-calendar-check'></i>
          </button>

          <button class='btn btn-warning btn-sm rounded-pill'
            title='Edit'
            onclick=\"openInParent('kelola_guru/edit.php?id={$d['id']}')\">
            <i class='bi bi-pencil'></i>
          </button>

          <button class='btn btn-danger btn-sm rounded-pill'
            title='Hapus'
            onclick=\"hapusGuru({$d['id']})\">
            <i class='bi bi-trash'></i>
          </button>

        </div>
      </td>
    </tr>";
    $no++;
  }
} else {
  echo "<tr><td colspan='8' class='text-center text-muted'>
        Data guru belum tersedia
        </td></tr>";
}
?>

</tbody>
</table>
</div>

</div>
</div>

<script src="../../bootstrap-5.3.8-dist/js/bootstrap.bundle.min.js"></script>

<script>
function openInParent(path){
  try {
    parent.document.getElementById('iframeContent').src = path;
  } catch {
    window.location.href = path;
  }
}

function hapusGuru(id){
  Swal.fire({
    title:'Hapus Data?',
    text:'Data guru akan dihapus permanen',
    icon:'warning',
    showCancelButton:true,
    confirmButtonColor:'#dc3545',
    cancelButtonColor:'#0d6efd',
    confirmButtonText:'Ya, hapus'
  }).then(res=>{
    if(res.isConfirmed){
      fetch('hapus.php?id='+id)
      .then(()=>{
        Swal.fire({
          icon:'success',
          title:'Berhasil',
          timer:1200,
          showConfirmButton:false
        }).then(()=>location.reload());
      });
    }
  });
}
</script>

</body>
</html>
