<?php
include '../../koneksi.php';

if (!isset($_GET['id'])) {
  die("ID tidak ditemukan");
}

$id    = $_GET['id'];
$kelas = $_GET['kelas'] ?? '';

$data = mysqli_fetch_assoc(mysqli_query($koneksi,
  "SELECT * FROM jadwal_kelas WHERE id='$id'"
));
if (!$data) die("Data tidak ditemukan");

$success = false;

if (isset($_POST['update'])) {
  mysqli_query($koneksi,"
    UPDATE jadwal_kelas SET
      hari='$_POST[hari]',
      jam_mulai='$_POST[jam_mulai]',
      jam_selesai='$_POST[jam_selesai]',
      mapel='$_POST[mapel]',
      guru='$_POST[guru]',
      ruang='$_POST[ruang]'
    WHERE id='$id'
  ");

  $success = true;
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Edit Jadwal</title>

<link href="../../bootstrap-5.3.8-dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<style>
body { background:#f4f6f9; }
.card {
  border-radius:18px;
  box-shadow:0 12px 35px rgba(0,0,0,.12);
}
</style>
</head>

<body>

<div class="container-fluid mt-3">
<div class="card p-4">

<h4 class="fw-bold mb-4">
  <i class="bi bi-pencil-square"></i> Edit Jadwal
</h4>

<form method="post">

<div class="row g-3">
  <div class="col-md-4">
    <label class="form-label">Hari</label>
    <select name="hari" class="form-select" required>
      <?php foreach(['Senin','Selasa','Rabu','Kamis','Jumat'] as $h): ?>
        <option <?= $data['hari']==$h?'selected':'' ?>><?= $h ?></option>
      <?php endforeach; ?>
    </select>
  </div>

  <div class="col-md-4">
    <label class="form-label">Jam Mulai</label>
    <input type="time" name="jam_mulai"
      value="<?= $data['jam_mulai'] ?>" class="form-control" required>
  </div>

  <div class="col-md-4">
    <label class="form-label">Jam Selesai</label>
    <input type="time" name="jam_selesai"
      value="<?= $data['jam_selesai'] ?>" class="form-control" required>
  </div>

  <div class="col-md-6">
    <label class="form-label">Mata Pelajaran</label>
    <input type="text" name="mapel"
      value="<?= $data['mapel'] ?>" class="form-control" required>
  </div>

  <div class="col-md-6">
    <label class="form-label">Guru</label>
    <input type="text" name="guru"
      value="<?= $data['guru'] ?>" class="form-control">
  </div>

  <div class="col-md-6">
    <label class="form-label">Ruang</label>
    <input type="text" name="ruang"
      value="<?= $data['ruang'] ?>" class="form-control">
  </div>
</div>

<div class="d-flex gap-2 mt-4">
  <button name="update" class="btn btn-success rounded-pill px-4">
    <i class="bi bi-save"></i> Simpan
  </button>

  <button type="button" onclick="kembali()"
    class="btn btn-secondary rounded-pill px-4">
    Kembali
  </button>
</div>

</form>

</div>
</div>

<?php if ($success): ?>
<script>
Swal.fire({
  icon: 'success',
  title: 'Berhasil',
  text: 'Jadwal berhasil diperbarui',
  timer: 1500,
  showConfirmButton: false
}).then(() => {
  kembali();
});
</script>
<?php endif; ?>

<script>
function kembali() {
  try {
    parent.document.getElementById('iframeContent').src =
      'kelola_jadwal/jadwal.php?kelas=<?= urlencode($kelas) ?>';
  } catch {
    window.location.href =
      'jadwal.php?kelas=<?= urlencode($kelas) ?>';
  }
}
</script>

</body>
</html>
