<?php
include '../../koneksi.php';

$kelas = $_GET['kelas'] ?? '';

function openScript() {
echo "
<script>
function openInParent(path){
  try {
    parent.document.getElementById('iframeContent').src = path;
  } catch {
    window.location.href = path;
  }
}
</script>";
}
openScript();

/* =======================
   MAPEL IPA & IPS
======================= */
$mapelIPA = [
'Al-Qur’an Hadits','Akidah Akhlak','Fiqih','SKI',
'Bahasa Indonesia','Bahasa Inggris','Bahasa Arab',
'Matematika Wajib','Matematika Peminatan',
'Fisika','Kimia','Biologi',
'Sejarah Indonesia','PPKn',
'PJOK','Seni Budaya','Prakarya'
];

$mapelIPS = [
'Al-Qur’an Hadits','Akidah Akhlak','Fiqih','SKI',
'Bahasa Indonesia','Bahasa Inggris','Bahasa Arab',
'Matematika Wajib',
'Ekonomi','Geografi','Sosiologi','Sejarah Peminatan',
'Sejarah Indonesia','PPKn',
'PJOK','Seni Budaya','Prakarya'
];

/* =======================
   DATA GURU
======================= */
$qGuru = mysqli_query($koneksi,"
SELECT nama_lengkap,mapel
FROM guru
WHERE status='Aktif'
");
$guruList=[];
while($g=mysqli_fetch_assoc($qGuru)) $guruList[]=$g;

$hariList=['Senin','Selasa','Rabu','Kamis','Jumat'];
?>

<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Kelola Jadwal</title>

<link href="../../bootstrap-5.3.8-dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<style>
body{background:#f4f6f9}
.card{border-radius:18px;box-shadow:0 12px 35px rgba(0,0,0,.12)}
.filter-bar{
position:sticky;top:0;z-index:10;
background:#fff;padding:15px;
border-radius:12px;
box-shadow:0 6px 15px rgba(0,0,0,.08)
}
.table thead{
position:sticky;top:0;
background:linear-gradient(90deg,#1e6f91,#2a8fbd);
color:#fff
}
</style>
</head>

<body>

<div class="container-fluid mt-3">
<div class="card p-4">

<!-- HEADER -->
<div class="d-flex justify-content-between align-items-center mb-3">
<h4 class="fw-bold mb-0">
<i class="bi bi-calendar3"></i> Kelola Jadwal Pelajaran
</h4>

<?php if($kelas): ?>
<button class="btn btn-primary rounded-pill"
onclick="openInParent('kelola_jadwal/tambah.php?kelas=<?=urlencode($kelas)?>')">
<i class="bi bi-plus-circle"></i> Tambah Jadwal
</button>
<?php endif; ?>
</div>

<!-- FILTER -->
<form method="get" class="filter-bar mb-4">
<div class="row g-2 align-items-end">
<div class="col-md-4">
<label class="form-label">Pilih Kelas</label>
<select name="kelas" class="form-select" onchange="this.form.submit()">
<option value="">-- Semua Kelas --</option>
<?php
$kelasList=["X IPA","XI IPA","XII IPA","X IPS","XI IPS","XII IPS"];
foreach($kelasList as $k){
$sel=$kelas==$k?'selected':'';
echo "<option $sel>$k</option>";
}
?>
</select>
</div>

<?php if($kelas): ?>
<div class="col-md-3">
<a href="jadwal.php" class="btn btn-secondary rounded-pill px-4">
Reset
</a>
</div>
<?php endif; ?>
</div>
</form>

<!-- =======================
   TAB HARI
======================= -->
<ul class="nav nav-pills mb-3">
<?php foreach($hariList as $i=>$h): ?>
<li class="nav-item">
<button class="nav-link <?= $i==0?'active':'' ?>"
data-bs-toggle="pill"
data-bs-target="#<?= $h ?>">
<?= $h ?>
</button>
</li>
<?php endforeach; ?>
</ul>

<div class="tab-content">
<?php foreach($hariList as $i=>$hari): ?>
<div class="tab-pane fade <?= $i==0?'show active':'' ?>" id="<?= $hari ?>">

<div class="table-responsive">
<table class="table table-hover align-middle">
<thead>
<tr>
<th>Jam</th>
<th>Kelas</th>
<th>Mapel</th>
<th>Guru</th>
<th>Ruang</th>
<?php if($kelas): ?><th class="text-center">Aksi</th><?php endif; ?>
</tr>
</thead>
<tbody>

<?php
$where = $kelas ? "AND kelas='$kelas'" : "";
$q=mysqli_query($koneksi,"
SELECT * FROM jadwal_kelas
WHERE hari='$hari' $where
ORDER BY jam_mulai ASC
");

if(mysqli_num_rows($q)){
while($d=mysqli_fetch_assoc($q)){
?>
<tr>
<td><?= $d['jam_mulai'].' - '.$d['jam_selesai'] ?></td>
<td><?= $d['kelas'] ?></td>
<td><?= $d['mapel'] ?></td>
<td><?= $d['guru'] ?></td>
<td><?= $d['ruang'] ?></td>

<?php if($kelas): ?>
<td class="text-center">
<button class="btn btn-warning btn-sm rounded-pill"
onclick="openInParent('kelola_jadwal/edit.php?id=<?=$d['id']?>&kelas=<?=urlencode($kelas)?>')">
<i class="bi bi-pencil"></i>
</button>
<button class="btn btn-danger btn-sm rounded-pill"
onclick="hapusJadwal(<?=$d['id']?>)">
<i class="bi bi-trash"></i>
</button>
</td>
<?php endif; ?>
</tr>
<?php }} else { ?>
<tr>
<td colspan="<?= $kelas?6:5 ?>" class="text-center text-muted">
Belum ada jadwal
</td>
</tr>
<?php } ?>

</tbody>
</table>
</div>

</div>
<?php endforeach; ?>
</div>

</div>
</div>

<script src="../../bootstrap-5.3.8-dist/js/bootstrap.bundle.min.js"></script>

<?php if($kelas): ?>
<script>
function hapusJadwal(id){
Swal.fire({
title:'Hapus Jadwal?',
text:'Data tidak bisa dikembalikan!',
icon:'warning',
showCancelButton:true,
confirmButtonColor:'#dc3545'
}).then(res=>{
if(res.isConfirmed){
fetch('hapus.php?id='+id)
.then(()=>location.reload());
}
});
}
</script>
<?php endif; ?>

</body>
</html>
