<?php
include '../../koneksi.php';

$kelas       = $_GET['kelas'] ?? '';
$tahun_lahir = $_GET['tahun_lahir'] ?? '';
$usia_min    = $_GET['usia_min'] ?? '';
$usia_max    = $_GET['usia_max'] ?? '';
$search      = $_GET['search'] ?? '';
$limit       = $_GET['limit'] ?? 10;

$where = "WHERE 1=1";

if ($kelas != '') {
  $where .= " AND kelas='$kelas'";
}

if ($tahun_lahir != '') {
  $where .= " AND YEAR(tanggal_lahir)='$tahun_lahir'";
}

if ($usia_min != '') {
  $where .= " AND TIMESTAMPDIFF(YEAR, tanggal_lahir, CURDATE()) >= '$usia_min'";
}

if ($usia_max != '') {
  $where .= " AND TIMESTAMPDIFF(YEAR, tanggal_lahir, CURDATE()) <= '$usia_max'";
}

if ($search != '') {
  $where .= " AND (nama_lengkap LIKE '%$search%' OR nisn LIKE '%$search%')";
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Kelola Siswa</title>

<link href="../../bootstrap-5.3.8-dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<style>
body { background:#f4f6f9; }
.card {
  border-radius:18px;
  box-shadow:0 12px 35px rgba(0,0,0,.12);
}
.filter-bar {
  position: sticky;
  top: 0;
  z-index: 10;
  background: #fff;
  padding: 15px;
  border-radius: 12px;
  box-shadow: 0 6px 15px rgba(0,0,0,.08);
}
.table-wrapper {
  max-height:60vh;
  overflow-y:auto;
}
.table thead {
  position:sticky;
  top:0;
  background:linear-gradient(90deg,#1e6f91,#2a8fbd);
  color:#fff;
}
.table-hover tbody tr:hover {
  background:rgba(13,202,240,.08);
  transition:.3s;
}
</style>
</head>

<body>

<div class="container-fluid mt-3">
<div class="card p-4">

<!-- HEADER -->
<div class="d-flex justify-content-between align-items-center mb-3">
  <h4 class="fw-bold mb-0">
    <i class="bi bi-people-fill"></i> Data Siswa
  </h4>

  <button class="btn btn-primary rounded-pill"
    onclick="openInParent('kelola_siswa/tambah.php')">
    <i class="bi bi-plus-circle"></i> Tambah Siswa
  </button>
</div>

<!-- FILTER -->
<form method="get" class="filter-bar mb-3">
<div class="row g-2 align-items-end">

  <div class="col-md-2">
    <label class="form-label">Kelas</label>
    <select name="kelas" class="form-select">
      <option value="">Semua</option>
      <?php foreach(['X IPA','X IPS','XI IPA','XI IPS','XII IPA','XII IPS'] as $k): ?>
        <option <?= $kelas==$k?'selected':'' ?>><?= $k ?></option>
      <?php endforeach; ?>
    </select>
  </div>

  <div class="col-md-2">
    <label class="form-label">Tahun Lahir</label>
    <input type="number" name="tahun_lahir" value="<?= $tahun_lahir ?>"
      class="form-control" placeholder="2006">
  </div>

  <div class="col-md-1">
    <label class="form-label">Usia Min</label>
    <input type="number" name="usia_min" value="<?= $usia_min ?>" class="form-control">
  </div>

  <div class="col-md-1">
    <label class="form-label">Usia Max</label>
    <input type="number" name="usia_max" value="<?= $usia_max ?>" class="form-control">
  </div>

  <div class="col-md-3">
    <label class="form-label">Cari</label>
    <input type="text" name="search" value="<?= $search ?>"
      class="form-control" placeholder="Nama / NISN">
  </div>

  <div class="col-md-1">
    <label class="form-label">Limit</label>
    <select name="limit" class="form-select">
      <?php foreach([10,25,50,100] as $l): ?>
        <option value="<?= $l ?>" <?= $limit==$l?'selected':'' ?>><?= $l ?></option>
      <?php endforeach; ?>
    </select>
  </div>

  <div class="col-md-2 d-flex gap-2">
    <button class="btn btn-info text-white rounded-pill w-100">
      <i class="bi bi-funnel"></i>
    </button>
    <a href="siswa.php" class="btn btn-secondary rounded-pill w-100">
      Reset
    </a>
  </div>

</div>
</form>

<!-- TABLE -->
<div class="table-wrapper">
<table class="table table-hover align-middle">
<thead>
<tr>
  <th>No</th>
  <th>NISN</th>
  <th>Nama</th>
  <th>Kelas</th>
  <th>TTL</th>
  <th>Usia</th>
  <th>No. WA</th>
  <th>Email</th>
  <th class="text-center">Aksi</th>
</tr>
</thead>
<tbody>

<?php
$no = 1;
$q = mysqli_query($koneksi,"
  SELECT *,
  TIMESTAMPDIFF(YEAR, tanggal_lahir, CURDATE()) AS usia
  FROM siswa
  $where
  ORDER BY nama_lengkap ASC
  LIMIT $limit
");

if ($q && mysqli_num_rows($q) > 0) {
  while ($d = mysqli_fetch_assoc($q)) {
    echo "
    <tr>
      <td>{$no}</td>
      <td>{$d['nisn']}</td>
      <td>{$d['nama_lengkap']}</td>
      <td><span class='badge bg-primary'>{$d['kelas']}</span></td>
      <td>{$d['tempat_lahir']}, {$d['tanggal_lahir']}</td>
      <td>{$d['usia']} th</td>
      <td>{$d['no_wa']}</td>
      <td>{$d['email']}</td>
      <td class='text-center'>
        <button class='btn btn-warning btn-sm rounded-pill'
          onclick=\"openInParent('kelola_siswa/edit.php?id={$d['id']}')\">
          <i class='bi bi-pencil'></i>
        </button>
        <button class='btn btn-danger btn-sm rounded-pill'
          onclick=\"hapusSiswa({$d['user_id']})\">
          <i class='bi bi-trash'></i>
        </button>
      </td>
    </tr>";
    $no++;
  }
} else {
  echo "<tr><td colspan='9' class='text-center text-muted'>Data tidak ditemukan</td></tr>";
}
?>

</tbody>
</table>
</div>

</div>
</div>

<script src="../../bootstrap-5.3.8-dist/js/bootstrap.bundle.min.js"></script>

<script>
function openInParent(path){
  try {
    parent.document.getElementById('iframeContent').src = path;
  } catch {
    window.location.href = path;
  }
}

function hapusSiswa(user_id){
  Swal.fire({
    title:'Hapus Data?',
    text:'Data siswa akan dihapus permanen',
    icon:'warning',
    showCancelButton:true,
    confirmButtonColor:'#dc3545',
    cancelButtonColor:'#0d6efd',
    confirmButtonText:'Ya, hapus'
  }).then(res=>{
    if(res.isConfirmed){
      fetch('hapus.php?id='+user_id)
      .then(()=>location.reload());
    }
  });
}
</script>

</body>
</html>
