<?php
include '../../koneksi.php';

$success = false;
$error   = '';

if (isset($_POST['simpan'])) {

  $username = mysqli_real_escape_string($koneksi, $_POST['username']);
  $password = password_hash($_POST['password'], PASSWORD_DEFAULT);

  $nisn          = mysqli_real_escape_string($koneksi, $_POST['nisn']);
  $nama_lengkap  = mysqli_real_escape_string($koneksi, $_POST['nama_lengkap']);
  $kelas         = $_POST['kelas'];
  $alamat        = mysqli_real_escape_string($koneksi, $_POST['alamat']);
  $tempat_lahir  = mysqli_real_escape_string($koneksi, $_POST['tempat_lahir']);
  $tanggal_lahir = $_POST['tanggal_lahir'];
  $no_wa         = mysqli_real_escape_string($koneksi, $_POST['no_wa']);
  $email         = mysqli_real_escape_string($koneksi, $_POST['email']);
  $nama_ayah     = mysqli_real_escape_string($koneksi, $_POST['nama_ayah']);
  $nama_ibu      = mysqli_real_escape_string($koneksi, $_POST['nama_ibu']);

  // insert user
  $qUser = mysqli_query($koneksi, "
    INSERT INTO users (username,password,role)
    VALUES ('$username','$password','siswa')
  ");

  if ($qUser) {
    $user_id = mysqli_insert_id($koneksi);

    mysqli_query($koneksi, "
      INSERT INTO siswa
      (user_id, nisn, nama_lengkap, kelas, alamat, tempat_lahir, tanggal_lahir, no_wa, email, nama_ayah, nama_ibu)
      VALUES
      ('$user_id','$nisn','$nama_lengkap','$kelas','$alamat','$tempat_lahir','$tanggal_lahir','$no_wa','$email','$nama_ayah','$nama_ibu')
    ");

    $success = true;
  } else {
    $error = "Username sudah digunakan!";
  }
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Tambah Siswa</title>

<link href="../../bootstrap-5.3.8-dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<style>
body { background:#f4f6f9; }
.card {
  border-radius:18px;
  box-shadow:0 12px 35px rgba(0,0,0,.12);
}
</style>
</head>

<body>

<div class="container-fluid mt-3">
<div class="card p-4">

<h4 class="fw-bold mb-4">
  <i class="bi bi-person-plus-fill"></i> Tambah Data Siswa
</h4>

<form method="POST">

<div class="row">
  <div class="col-md-6 mb-3">
    <label class="form-label">Username</label>
    <input type="text" name="username" class="form-control" required>
  </div>
  <div class="col-md-6 mb-3">
    <label class="form-label">Password</label>
    <input type="password" name="password" class="form-control" required>
  </div>
</div>

<div class="mb-3">
  <label class="form-label">NISN</label>
  <input type="text" name="nisn" class="form-control" required>
</div>

<div class="mb-3">
  <label class="form-label">Nama Lengkap</label>
  <input type="text" name="nama_lengkap" class="form-control" required>
</div>

<div class="mb-3">
  <label class="form-label">Kelas</label>
  <select name="kelas" class="form-select" required>
    <option value="">-- Pilih Kelas --</option>
    <option>X IPA</option>
    <option>X IPS</option>
    <option>XI IPA</option>
    <option>XI IPS</option>
    <option>XII IPA</option>
    <option>XII IPS</option>
  </select>
</div>

<div class="mb-3">
  <label class="form-label">Alamat</label>
  <textarea name="alamat" class="form-control" rows="2" required></textarea>
</div>

<div class="row">
  <div class="col-md-6 mb-3">
    <label class="form-label">Tempat Lahir</label>
    <input type="text" name="tempat_lahir" class="form-control" required>
  </div>
  <div class="col-md-6 mb-3">
    <label class="form-label">Tanggal Lahir</label>
    <input type="date" name="tanggal_lahir" class="form-control" required>
  </div>
</div>

<div class="mb-3">
  <label class="form-label">No WhatsApp</label>
  <input type="text" name="no_wa" class="form-control" required>
</div>

<div class="mb-3">
  <label class="form-label">Email</label>
  <input type="email" name="email" class="form-control" required>
</div>

<div class="row">
  <div class="col-md-6 mb-3">
    <label class="form-label">Nama Ayah</label>
    <input type="text" name="nama_ayah" class="form-control" required>
  </div>
  <div class="col-md-6 mb-3">
    <label class="form-label">Nama Ibu</label>
    <input type="text" name="nama_ibu" class="form-control" required>
  </div>
</div>

<div class="d-flex gap-2 mt-3">
  <button name="simpan" class="btn btn-success rounded-pill px-4">
    <i class="bi bi-check-circle"></i> Simpan
  </button>

  <button type="button" onclick="kembali()"
    class="btn btn-secondary rounded-pill px-4">
    Kembali
  </button>
</div>

<?php if($error): ?>
  <div class="alert alert-danger mt-3"><?= $error ?></div>
<?php endif; ?>

</form>

</div>
</div>

<?php if ($success): ?>
<script>
Swal.fire({
  icon:'success',
  title:'Berhasil',
  text:'Data siswa berhasil ditambahkan',
  timer:1500,
  showConfirmButton:false
}).then(() => {
  try {
    parent.document.getElementById('iframeContent').src = 'kelola_siswa/siswa.php';
  } catch {
    window.location.href = 'siswa.php';
  }
});
</script>
<?php endif; ?>

<script>
function kembali(){
  try {
    parent.document.getElementById('iframeContent').src = 'kelola_siswa/siswa.php';
  } catch {
    window.location.href = 'siswa.php';
  }
}
</script>

</body>
</html>
