<?php
session_start();
include '../koneksi.php';

date_default_timezone_set('Asia/Jakarta');

// Cek role guru
if (!isset($_SESSION['id']) || $_SESSION['role'] != 'guru') {
    header("Location: ../login.php");
    exit;
}

$user_id = $_SESSION['id'];
$tanggal = date("Y-m-d");
$jam     = date("H:i:s");

// 🔥 AMBIL ID GURU DARI user_id
$qGuru = mysqli_query($koneksi, "SELECT id FROM guru WHERE user_id='$user_id'");
$guru  = mysqli_fetch_assoc($qGuru);

if (!$guru) {
    die("Data guru tidak ditemukan.");
}

$guru_id = $guru['id']; // INI YANG BENAR

// Cek apakah sudah absen hari ini
$cek = mysqli_query(
    $koneksi,
    "SELECT id FROM absensi_guru 
     WHERE guru_id='$guru_id' 
     AND tanggal='$tanggal'"
);

if (mysqli_num_rows($cek) > 0) {
    $status = 'sudah';
} else {
    // Insert absen masuk
    mysqli_query(
        $koneksi,
        "INSERT INTO absensi_guru 
         (guru_id, tanggal, jam_masuk, status)
         VALUES 
         ('$guru_id', '$tanggal', '$jam', 'Hadir')"
    );
    $status = 'berhasil';
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<title>Absen Masuk | MAYABSEN</title>

<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600;700&display=swap" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<style>
body{
    margin:0;
    padding:0;
    background:#f4f8f6;
    font-family:'Poppins',sans-serif;
}

/* CARD ALERT */
.swal2-popup{
    border-radius:26px !important;
    padding:32px 28px !important;
}

/* HILANGKAN RING / OUTLINE */
.swal2-confirm:focus,
.swal2-confirm:active{
    box-shadow:none !important;
    outline:none !important;
}

/* BUTTON OK PASTEL SMOOTH */
.swal2-confirm{
    background:#b7e4c7 !important;       /* pastel green */
    color:#1b4332 !important;
    border-radius:50px !important;
    padding:10px 38px !important;
    font-weight:600;
    font-size:.95rem;
    border:none !important;
    box-shadow:0 8px 18px rgba(0,0,0,.12);
    transition:.25s ease;
}

.swal2-confirm:hover{
    background:#95d5b2 !important;
    transform:translateY(-1px);
    box-shadow:0 10px 22px rgba(0,0,0,.16);
}
</style>
</head>

<body>

<script>
<?php if($status === 'sudah'): ?>
Swal.fire({
    html: `
        <div style="font-size:3.2rem;color:#f0ad4e;">
            <i class="bi bi-info-circle-fill"></i>
        </div>
        <h4 class="mt-3 fw-bold">Sudah Absen Masuk</h4>
        <p class="text-muted mb-0" style="font-size:.95rem;">
            Kamu sudah melakukan absen masuk hari ini ✨<br>
            Silakan lanjutkan aktivitas mengajar 🌱
        </p>
    `,
    confirmButtonText:'Oke, Mengerti',
    allowOutsideClick:false
}).then(() => {
    window.location.href = 'log_absen.php';
});

<?php else: ?>
Swal.fire({
    html: `
        <div style="font-size:3.4rem;color:#2e8b57;">
            <i class="bi bi-check-circle-fill"></i>
        </div>
        <h4 class="mt-3 fw-bold">Absen Masuk Berhasil</h4>
        <p class="text-muted mb-0" style="font-size:.95rem;">
            Terima kasih telah melakukan absen masuk 🌿<br>
            Semoga mengajar hari ini lancar dan menyenangkan!
        </p>
    `,
    confirmButtonText:'Oke',
    allowOutsideClick:false
}).then(() => {
    window.location.href = 'log_absen.php';
});
<?php endif; ?>
</script>

</body>
</html>
