<?php
session_start();
include '../koneksi.php';

if (!isset($_SESSION['id']) || $_SESSION['role'] != 'guru') {
    header("Location: ../login.php");
    exit;
}

$user_id = $_SESSION['id'];

/* ======================
   DATA GURU
====================== */
$query = mysqli_query($koneksi,"
    SELECT * FROM guru 
    WHERE email = (
        SELECT email FROM users WHERE id='$user_id'
    )
");
$guru = mysqli_fetch_assoc($query);

$data_lengkap = $guru 
    && $guru['nama_lengkap'] 
    && $guru['mapel'] 
    && $guru['no_wa'] 
    && $guru['email'];

$peringatan = !$data_lengkap 
    ? "Data guru kamu belum lengkap. Silakan lengkapi melalui menu Profil." 
    : "";

$nama_guru = $guru['nama_lengkap'] ?? 'Guru';

$foto_profil = "../assets/default-profile.png";
if (!empty($guru['foto']) && file_exists("../uploads/".$guru['foto'])) {
    $foto_profil = "../uploads/".$guru['foto'];
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Dashboard Guru | MAYABSEN</title>

<link href="../bootstrap-5.3.8-dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">

<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600;700&family=Playfair+Display:wght@600;700;800&display=swap" rel="stylesheet">

<style>
body{
    background:#f4f8f6;
    font-family:'Poppins',sans-serif;
}
.header{
    background:linear-gradient(180deg,#1e6f91,#144c66);
    color:#fff;
    padding:55px 16px 28px;
    border-radius:0 0 36px 36px;
    position:relative;
    text-align:center;
}
.profile-photo{
    width:165px;
    height:165px;
    border-radius:50%;
    object-fit:cover;
    box-shadow:0 12px 28px rgba(0,0,0,.28);
}
.profile-menu{
    position:absolute;
    top:14px;
    right:14px;
}
.profile-menu .btn{
    background:rgba(255,255,255,.25);
    border:none;
    color:#fff;
    border-radius:50%;
    width:44px;
    height:44px;
}
.profile-menu .btn:hover{
    background:#fff;
    color:#1f6f43;
}
.school-name{
    font-family:'Playfair Display',serif;
    font-weight:800;
    font-size:1.15rem;
    letter-spacing:1.6px;
    margin-top:4px;
    text-transform:uppercase;
}
#clock{
    font-size:.8rem;
    margin-top:6px;
    opacity:.9;
}
.menu-container{
    width:92%;
    margin:34px auto;
    display:grid;
    grid-template-columns:repeat(auto-fill,minmax(140px,1fr));
    gap:18px;
}
.menu-card{
    background:#fff;
    border-radius:22px;
    padding:26px 10px;
    text-align:center;
    box-shadow:0 6px 20px rgba(0,0,0,.08);
    transition:.25s ease;
}
.menu-card:hover{
    transform:translateY(-6px);
    box-shadow:0 12px 28px rgba(0,0,0,.15);
}
.menu-card i{
    font-size:2.6rem;
    color:#2e8b57;
}
.menu-card p{
    margin-top:10px;
    font-weight:600;
    font-size:14px;
}
.footer{
    text-align:center;
    font-size:13px;
    color:#666;
    padding-bottom:25px;
}
</style>
</head>

<body>

<div class="header">

    <!-- DROPDOWN -->
    <div class="dropdown profile-menu">
        <button class="btn" data-bs-toggle="dropdown">
            <i class="bi bi-person-fill"></i>
        </button>
        <ul class="dropdown-menu dropdown-menu-end">
            <li>
                <a class="dropdown-item" href="profil.php">
                    <i class="bi bi-person-circle me-2"></i>Profil
                </a>
            </li>
            <li><hr class="dropdown-divider"></li>
            <li>
                <a class="dropdown-item text-danger" href="../logout.php">
                    <i class="bi bi-box-arrow-right me-2"></i>Logout
                </a>
            </li>
        </ul>
    </div>

    <img src="<?= $foto_profil ?>" class="profile-photo">

    <h5 class="fw-bold mt-3 mb-1"><?= htmlspecialchars($nama_guru) ?></h5>
    <div class="school-name">Madrasah Aliyah Yasti Cisaat</div>
    <div id="clock"></div>
</div>

<?php if($peringatan): ?>
<div class="alert alert-warning text-center mt-3 mx-auto" style="width:92%;">
    <?= $peringatan ?>
</div>
<?php endif; ?>

<div class="menu-container">
    <div class="menu-card" onclick="location.href='absen_masuk.php'">
        <i class="bi bi-fingerprint"></i><p>Absen Masuk</p>
    </div>

    <div class="menu-card" onclick="location.href='absen_pulang.php'">
        <i class="bi bi-check2-square"></i><p>Absen Pulang</p>
    </div>

    <div class="menu-card" onclick="location.href='lihat_jadwal.php'">
        <i class="bi bi-calendar-week"></i><p>Jadwal Mengajar</p>
    </div>

    <div class="menu-card" onclick="location.href='log_absen.php'">
        <i class="bi bi-clock-history"></i><p>Log Absen</p>
    </div>

    <div class="menu-card" onclick="location.href='buat_form.php'">
        <i class="bi bi-pencil-square"></i><p>Buat Form</p>
    </div>

    <div class="menu-card" onclick="location.href='log_form.php'">
        <i class="bi bi-envelope-check"></i><p>Status Form</p>
    </div>

    <!-- ⭐ MENU TAMBAHAN -->
    <div class="menu-card" onclick="location.href='pendapatan.php'">
        <i class="bi bi-cash-coin"></i><p>Pendapatan</p>
    </div>
</div>

<div class="footer">
    © <?= date('Y'); ?> MAYABSEN — by Zani 💚
</div>

<script src="../bootstrap-5.3.8-dist/js/bootstrap.bundle.min.js"></script>
<script>
function updateClock(){
    const now = new Date();
    document.getElementById('clock').innerHTML =
        now.toLocaleDateString('id-ID',{weekday:'long',day:'numeric',month:'long',year:'numeric'}) +
        ' • ' + now.toLocaleTimeString('id-ID');
}
setInterval(updateClock,1000);
updateClock();
</script>

</body>
</html>
