<?php
session_start();
include '../koneksi.php';

if (!isset($_SESSION['id']) || $_SESSION['role'] != 'guru') {
    header("Location: ../login.php");
    exit;
}

$user_id = $_SESSION['id'];
$query = "SELECT * FROM form_izin WHERE user_id='$user_id' ORDER BY tanggal DESC";
$result = mysqli_query($koneksi, $query);
?>

<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Riwayat Form Izin Guru | MAYABSEN</title>

<link href="../bootstrap-5.3.8-dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600;700&display=swap" rel="stylesheet">

<style>
body{
    background:#f4f8f6;
    font-family:'Poppins',sans-serif;
}

/* BACK ARROW */
.back-arrow{
    position:fixed;
    top:18px;
    left:18px;
    font-size:1.6rem;
    color:#1b4332;
    text-decoration:none;
    z-index:20;
}

/* WRAPPER */
.page-wrapper{
    width:92%;
    margin:70px auto 30px;
}

/* CARD */
.card{
    border:none;
    border-radius:22px;
    box-shadow:0 12px 30px rgba(0,0,0,.10);
}

/* HEADER */
.page-title{
    font-weight:700;
    color:#1b4332;
}

/* BUTTON */
.btn-add{
    font-size:.85rem;
}

/* TABLE */
.table-wrapper{
    max-height:62vh;
    overflow-y:auto;
}
.table thead{
    position:sticky;
    top:0;
    z-index:5;
    background:linear-gradient(90deg,#52b788,#74c69d);
    color:#fff;
}
.table-hover tbody tr:hover{
    background-color:rgba(82,183,136,.08);
    transition:.3s;
}

/* BADGE */
.badge-izin{
    border-radius:20px;
    padding:6px 14px;
    font-weight:500;
    font-size:.75rem;
}

/* RESPONSIVE */
@media (min-width:576px){
    .btn-add{ font-size:.9rem; }
}
@media (min-width:992px){
    .page-wrapper{ max-width:950px; }
}
</style>
</head>

<body>

<!-- BACK -->
<a href="dashboard.php" class="back-arrow">
    <i class="bi bi-arrow-left"></i>
</a>

<div class="page-wrapper">
<div class="card p-4">

<!-- HEADER -->
<div class="text-center mb-4">
    <h4 class="page-title mb-1">
        <i class="bi bi-file-earmark-text-fill"></i>
        Riwayat Form Izin Guru
    </h4>
    <p class="text-muted mb-0">
        Semua izin Anda tercatat rapi 👨‍🏫✨
    </p>
</div>

<!-- BUTTON -->
<div class="text-end mb-3">
    <a href="buat_form.php" class="btn btn-success rounded-pill px-4 btn-add">
        <i class="bi bi-plus-circle"></i> Buat Form Izin
    </a>
</div>

<!-- TABLE -->
<div class="table-wrapper">
<table class="table table-hover align-middle">
<thead>
<tr>
    <th>No</th>
    <th>Tanggal</th>
    <th>Jenis</th>
    <th>Keterangan</th>
    <th>File</th>
    <th>Status</th>
</tr>
</thead>

<tbody>
<?php
$no = 1;
if (mysqli_num_rows($result) > 0) {
    while ($d = mysqli_fetch_assoc($result)) {

        $statusClass = match($d['status']) {
            'Disetujui' => 'bg-success',
            'Ditolak'   => 'bg-danger',
            'Menunggu'  => 'bg-warning text-dark',
            default     => 'bg-secondary'
        };

        $jenisIcon = match($d['jenis']) {
            'Izin'  => 'bi-envelope-paper',
            'Sakit' => 'bi-emoji-dizzy',
            'Dinas' => 'bi-briefcase',
            default => 'bi-file-text'
        };

        echo "
        <tr>
            <td>{$no}</td>
            <td>".date('d M Y', strtotime($d['tanggal']))."</td>
            <td>
                <span class='badge bg-primary badge-izin'>
                    <i class='bi {$jenisIcon}'></i> {$d['jenis']}
                </span>
            </td>
            <td>{$d['keterangan']}</td>
            <td>";

        if (!empty($d['file_surat'])) {
            echo "
                <a href='../uploads/{$d['file_surat']}' target='_blank'
                   class='btn btn-outline-dark btn-sm rounded-pill'>
                   <i class='bi bi-eye'></i>
                </a>";
        } else {
            echo "-";
        }

        echo "
            </td>
            <td>
                <span class='badge badge-izin {$statusClass}'>
                    {$d['status']}
                </span>
            </td>
        </tr>";

        $no++;
    }
} else {
    echo "
    <tr>
        <td colspan='6' class='text-center text-muted py-4'>
            <i class='bi bi-inbox fs-3'></i><br>
            Belum ada form izin yang diajukan
        </td>
    </tr>";
}
?>
</tbody>
</table>
</div>

</div>
</div>

<script src="../bootstrap-5.3.8-dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
