<?php
session_start();
include '../koneksi.php';

// Cek role guru
if (!isset($_SESSION['id']) || $_SESSION['role'] != 'guru') {
    header("Location: ../login.php");
    exit;
}

$user_id = $_SESSION['id'];

// Ambil data user
$user = mysqli_fetch_assoc(mysqli_query($koneksi, "SELECT * FROM users WHERE id='$user_id'"));
if (!$user) {
    echo "User tidak ditemukan.";
    exit;
}

// Ambil data guru berdasarkan username (mapping dengan NIP atau cara lain)
$guru = mysqli_fetch_assoc(mysqli_query($koneksi, "SELECT * FROM guru WHERE nip=(SELECT username FROM users WHERE id='$user_id') OR id='$user_id'"));
if (!$guru) {
    // fallback: jika tidak cocok NIP, ambil guru terbaru login
    $guru = mysqli_fetch_assoc(mysqli_query($koneksi, "SELECT * FROM guru ORDER BY id DESC LIMIT 1"));
}

// Foto default
$foto = "../assets/default-profile.png";
if (!empty($guru['foto']) && file_exists("../uploads/".$guru['foto'])) {
    $foto = "../uploads/" . htmlspecialchars($guru['foto']);
}

// Konversi jenis kelamin
$jenis_kelamin = $guru['jenis_kelamin'] == 'L' ? 'Laki-laki' : 'Perempuan';
?>

<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Profil Guru | MAYABSEN</title>

<link href="../bootstrap-5.3.8-dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">

<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600;700&family=Montserrat:wght@600;700&display=swap" rel="stylesheet">

<style>
body{
    background:#f4f8f6;
    font-family:'Poppins',sans-serif;
    min-height:100vh;
}
.profile-top{
    text-align:center;
    padding:35px 16px 20px;
    position:relative;
}
.profile-photo{
    width:150px;
    height:150px;
    border-radius:50%;
    object-fit:cover;
    box-shadow:0 10px 28px rgba(0,0,0,.25);
}
.profile-name{
    margin-top:14px;
    font-weight:700;
}
.profile-class{
    font-size:.85rem;
}
.btn-back{
    position:absolute;
    top:20px;
    left:20px;
    border:none;
    width:42px;
    height:42px;
    border-radius:50%;
}
.card-profil{
    width:92%;
    margin:10px auto 25px;
    background:#fff;
    border-radius:22px;
    padding:22px;
    box-shadow:0 10px 30px rgba(0,0,0,.08);
}
.data-row{
    display:flex;
    justify-content:space-between;
    align-items:center;
    padding:10px 0;
    border-bottom:1px dashed #e0e0e0;
    font-size:14px;
}
.data-row:last-child{
    border-bottom:none;
}
.data-label{
    color:#777;
}
.data-value{
    font-weight:600;
    text-align:right;
}
.section-title{
    font-family:'Montserrat',sans-serif;
    font-weight:700;
    font-size:.9rem;
    letter-spacing:.6px;
    margin:18px 0 8px;
    color:#2e8b57;
}
.badge-custom{
    background:#e6f4f1;
    color:#2e8b57;
    font-weight:600;
    font-size:.75rem;
}
.btn-edit{
    margin-top:20px;
    padding:10px;
    font-weight:600;
}
</style>
</head>

<body>

<div class="profile-top">
    <a href="dashboard.php" class="btn btn-back">
        <i class="bi bi-arrow-left"></i>
    </a>

    <img src="<?= $foto ?>" class="profile-photo" alt="Profil">
    <h5 class="profile-name"><?= htmlspecialchars($guru['nama_lengkap']) ?></h5>
    <span class="badge badge-custom"><?= htmlspecialchars($guru['jabatan']) ?></span>
</div>

<div class="card-profil">

    <div class="section-title">INFORMASI GURU</div>

    <div class="data-row">
        <span class="data-label">NIP</span>
        <span class="data-value"><?= $guru['nip'] ?></span>
    </div>
    <div class="data-row">
        <span class="data-label">Tempat Lahir</span>
        <span class="data-value"><?= $guru['tempat_lahir'] ?></span>
    </div>
    <div class="data-row">
        <span class="data-label">Tanggal Lahir</span>
        <span class="data-value"><?= date('d F Y', strtotime($guru['tanggal_lahir'])) ?></span>
    </div>
    <div class="data-row">
        <span class="data-label">Jenis Kelamin</span>
        <span class="data-value"><?= $jenis_kelamin ?></span>
    </div>
    <div class="data-row">
        <span class="data-label">Alamat</span>
        <span class="data-value"><?= $guru['alamat'] ?></span>
    </div>
    <div class="data-row">
        <span class="data-label">No. WhatsApp</span>
        <span class="data-value"><?= $guru['no_wa'] ?></span>
    </div>
    <div class="data-row">
        <span class="data-label">Email</span>
        <span class="data-value"><?= $guru['email'] ?></span>
    </div>
    <div class="data-row">
        <span class="data-label">Mata Pelajaran</span>
        <span class="data-value"><?= $guru['mapel'] ?></span>
    </div>
    <div class="data-row">
        <span class="data-label">Jabatan</span>
        <span class="data-value"><?= $guru['jabatan'] ?></span>
    </div>
    <div class="data-row">
        <span class="data-label">Status</span>
        <span class="data-value"><?= $guru['status'] ?></span>
    </div>

    <a href="edit_data_diri.php" class="btn btn-success w-100 rounded-pill btn-edit">
        <i class="bi bi-pencil-square me-1"></i> Edit Profil
    </a>
</div>

<script src="../bootstrap-5.3.8-dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
