<?php
session_start();
include '../koneksi.php';

if (!isset($_SESSION['id']) || $_SESSION['role'] !== 'siswa') {
    header("Location: ../login.php");
    exit;
}

$user_id = $_SESSION['id'];
$query = mysqli_query($koneksi, "SELECT * FROM siswa WHERE user_id='$user_id'");
$siswa = mysqli_fetch_assoc($query);

if (!$siswa) {
    die("Data siswa tidak ditemukan.");
}

$success = false;

if (isset($_POST['submit'])) {

    function esc($v){
        global $koneksi;
        return mysqli_real_escape_string($koneksi, $v);
    }

    $nisn          = esc($_POST['nisn']);
    $nama_lengkap  = esc($_POST['nama_lengkap']);
    $kelas         = esc($_POST['kelas']);
    $tempat_lahir  = esc($_POST['tempat_lahir']);
    $tanggal_lahir = esc($_POST['tanggal_lahir']);
    $alamat        = esc($_POST['alamat']);
    $no_wa         = esc($_POST['no_wa']);
    $email         = esc($_POST['email']);
    $nama_ayah     = esc($_POST['nama_ayah']);
    $nama_ibu      = esc($_POST['nama_ibu']);

    $foto_nama = $siswa['foto'];
    if (!empty($_FILES['foto']['name'])) {
        $ext = strtolower(pathinfo($_FILES['foto']['name'], PATHINFO_EXTENSION));
        if (in_array($ext,['jpg','jpeg','png'])) {
            $foto_nama = 'siswa_'.$user_id.'.'.$ext;
            move_uploaded_file($_FILES['foto']['tmp_name'], "../uploads/".$foto_nama);
        }
    }

    mysqli_query($koneksi,"
        UPDATE siswa SET
        nisn='$nisn',
        nama_lengkap='$nama_lengkap',
        kelas='$kelas',
        tempat_lahir='$tempat_lahir',
        tanggal_lahir='$tanggal_lahir',
        alamat='$alamat',
        no_wa='$no_wa',
        email='$email',
        nama_ayah='$nama_ayah',
        nama_ibu='$nama_ibu',
        foto='$foto_nama'
        WHERE user_id='$user_id'
    ");

    $success = true;
}

$foto_preview = "../assets/default-profile.png";
if (!empty($siswa['foto']) && file_exists("../uploads/".$siswa['foto'])) {
    $foto_preview = "../uploads/".$siswa['foto'];
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Edit Data Diri | MAYABSEN</title>

<link href="../bootstrap-5.3.8-dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600;700&display=swap" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<style>
body{
    background:#f4f8f6;
    font-family:'Poppins',sans-serif;
    color:#555;
}
.form-wrapper{
    width:92%;
    max-width:720px;
    margin:30px auto;
}
.card-form{
    background:#fff;
    border-radius:22px;
    padding:26px;
    box-shadow:0 10px 30px rgba(0,0,0,.08);
}
.section-title{
    font-weight:700;
    font-size:.85rem;
    letter-spacing:.7px;
    color:#2e8b57;
    margin:18px 0 10px;
}
.form-floating label{
    color:#777;
}
.photo-preview{
    width:120px;
    height:120px;
    border-radius:50%;
    object-fit:cover;
    box-shadow:0 8px 20px rgba(0,0,0,.2);
    margin-bottom:12px;
}

/* BUTTON SAVE PREMIUM */
.btn-save{
    background:linear-gradient(135deg,#2e8b57,#1f6f43);
    color:#fff;
    border:none;
    font-weight:600;
    letter-spacing:.3px;
    box-shadow:0 8px 18px rgba(46,139,87,.35);
}
.btn-save:hover{
    background:linear-gradient(135deg,#257a4c,#1a5f39);
    color:#fff;
}
</style>
</head>

<body>

<div class="form-wrapper">
<div class="card-form">

<div class="mb-3">
    <a href="profil.php" class="text-secondary">
        <i class="bi bi-arrow-left fs-4"></i>
    </a>
</div>

<form method="POST" enctype="multipart/form-data">

<div class="section-title">DATA SISWA</div>

<div class="form-floating mb-3">
    <input type="text" name="nisn" class="form-control" value="<?= $siswa['nisn'] ?>" required>
    <label>NISN</label>
</div>

<div class="form-floating mb-3">
    <input type="text" name="nama_lengkap" class="form-control" value="<?= $siswa['nama_lengkap'] ?>" required>
    <label>Nama Lengkap</label>
</div>

<div class="form-floating mb-3">
    <select name="kelas" class="form-select" required>
        <option value="">Pilih Kelas</option>
        <?php
        $kelas = ['X IPA','X IPS','XI IPA','XI IPS','XII IPA','XII IPS'];
        foreach($kelas as $k){
            $sel = $siswa['kelas']==$k?'selected':'';
            echo "<option $sel>$k</option>";
        }
        ?>
    </select>
    <label>Kelas</label>
</div>

<div class="row g-3">
    <div class="col-md-6 form-floating">
        <input type="text" name="tempat_lahir" class="form-control" value="<?= $siswa['tempat_lahir'] ?>" required>
        <label>Tempat Lahir</label>
    </div>
    <div class="col-md-6 form-floating">
        <input type="date" name="tanggal_lahir" class="form-control" value="<?= $siswa['tanggal_lahir'] ?>" required>
        <label>Tanggal Lahir</label>
    </div>
</div>

<div class="form-floating my-3">
    <textarea name="alamat" class="form-control" style="height:90px" required><?= $siswa['alamat'] ?></textarea>
    <label>Alamat</label>
</div>

<div class="row g-3">
    <div class="col-md-6 form-floating">
        <input type="text" name="no_wa" class="form-control" value="<?= $siswa['no_wa'] ?>" required>
        <label>No WhatsApp</label>
    </div>
    <div class="col-md-6 form-floating">
        <input type="email" name="email" class="form-control" value="<?= $siswa['email'] ?>" required>
        <label>Email</label>
    </div>
</div>

<div class="section-title">DATA ORANG TUA</div>

<div class="row g-3">
    <div class="col-md-6 form-floating">
        <input type="text" name="nama_ayah" class="form-control" value="<?= $siswa['nama_ayah'] ?>" required>
        <label>Nama Ayah</label>
    </div>
    <div class="col-md-6 form-floating">
        <input type="text" name="nama_ibu" class="form-control" value="<?= $siswa['nama_ibu'] ?>" required>
        <label>Nama Ibu</label>
    </div>
</div>

<div class="section-title">FOTO PROFIL</div>

<div class="text-center">
    <img id="previewFoto" src="<?= $foto_preview ?>" class="photo-preview">
</div>

<input type="file" name="foto" class="form-control mt-2" accept="image/*" onchange="previewImage(this)">

<button name="submit" class="btn btn-save w-100 rounded-pill py-2 mt-4">
    <i class="bi bi-save me-1"></i> Simpan Perubahan
</button>

</form>
</div>
</div>

<script>
function previewImage(input){
    if(input.files && input.files[0]){
        const reader = new FileReader();
        reader.onload = e => document.getElementById('previewFoto').src = e.target.result;
        reader.readAsDataURL(input.files[0]);
    }
}
</script>

<?php if($success): ?>
<script>
Swal.fire({
    icon:'success',
    title:'Berhasil!',
    text:'Data berhasil diperbarui',
    showConfirmButton:false,
    timer:1300
});
setTimeout(()=>window.location='dashboard.php',1300);
</script>
<?php endif; ?>

<script src="../bootstrap-5.3.8-dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
