<?php
session_start();
include '../koneksi.php';

if (!isset($_SESSION['id']) || $_SESSION['role'] != 'siswa') {
    header("Location: ../login.php");
    exit;
}

$user_id = $_SESSION['id'];
$querySiswa = mysqli_query($koneksi, "SELECT * FROM siswa WHERE user_id='$user_id'");
$siswa = mysqli_fetch_assoc($querySiswa);

$kelas_siswa = $siswa['kelas'] ?? "";
$kelas = isset($_GET['kelas']) ? mysqli_real_escape_string($koneksi, $_GET['kelas']) : $kelas_siswa;

$hariList = ['Senin','Selasa','Rabu','Kamis','Jumat'];
?>

<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Jadwal Pelajaran | MAYABSEN</title>

<link href="../bootstrap-5.3.8-dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600;700&display=swap" rel="stylesheet">

<style>
body{
    background:#f4f8f6;
    font-family:'Poppins',sans-serif;
}
.back-arrow{
    position:fixed;
    top:18px;
    left:18px;
    font-size:1.6rem;
    color:#1b4332;
    text-decoration:none;
    z-index:20;
}
.page-wrapper{
    width:92%;
    margin:70px auto 30px;
}
.card{
    border:none;
    border-radius:22px;
    box-shadow:0 12px 30px rgba(0,0,0,.10);
}
.page-title{
    font-weight:700;
    color:#1b4332;
}
.form-select{
    border-radius:14px;
}
.form-select:focus{
    box-shadow:none;
    border-color:#52b788;
}
.nav-pills .nav-link{
    border-radius:14px;
    font-weight:600;
    color:#1b4332;
}
.nav-pills .nav-link.active{
    background:#0d6efd;
}
.table thead{
    background:linear-gradient(90deg,#52b788,#74c69d);
    color:#fff;
}
.table-hover tbody tr:hover{
    background:rgba(82,183,136,.08);
}
.badge-mapel{
    border-radius:20px;
    padding:6px 14px;
    font-size:.75rem;
}
@media (min-width:992px){
    .page-wrapper{ max-width:980px; }
}
</style>
</head>

<body>

<a href="dashboard.php" class="back-arrow">
    <i class="bi bi-arrow-left"></i>
</a>

<div class="page-wrapper">
<div class="card p-4">

<!-- HEADER -->
<div class="text-center mb-4">
    <h4 class="page-title mb-1">
        <i class="bi bi-calendar-week-fill"></i> Jadwal Pelajaran
    </h4>
    <p class="text-muted mb-0">
        Jadwal belajar kamu tersusun rapi & mudah dipahami ✨
    </p>
</div>

<!-- FILTER KELAS -->
<form method="GET" class="mb-4">
    <label class="form-label fw-semibold">
        <i class="bi bi-building"></i> Pilih Kelas
    </label>
    <select name="kelas" class="form-select" onchange="this.form.submit()" required>
        <option value="">-- Pilih Kelas --</option>
        <?php
        $kelasList = ["X IPA","XI IPA","XII IPA","X IPS","XI IPS","XII IPS"];
        foreach($kelasList as $k){
            $sel = ($kelas == $k) ? "selected" : "";
            echo "<option value='$k' $sel>$k</option>";
        }
        ?>
    </select>
</form>

<?php if($kelas): ?>

<!-- TAB HARI -->
<ul class="nav nav-pills mb-3 justify-content-center">
<?php foreach($hariList as $i=>$h): ?>
<li class="nav-item">
    <button class="nav-link <?= $i==0?'active':'' ?>"
        data-bs-toggle="pill"
        data-bs-target="#hari<?= $i ?>">
        <?= $h ?>
    </button>
</li>
<?php endforeach; ?>
</ul>

<div class="tab-content">

<?php foreach($hariList as $i=>$hari): ?>
<div class="tab-pane fade <?= $i==0?'show active':'' ?>" id="hari<?= $i ?>">

<div class="table-responsive">
<table class="table table-hover align-middle text-center">
<thead>
<tr>
    <th>No</th>
    <th>Jam</th>
    <th>Mapel</th>
    <th>Guru</th>
    <th>Ruang</th>
</tr>
</thead>
<tbody>

<?php
$no = 1;
$q = mysqli_query($koneksi,"
    SELECT * FROM jadwal_kelas
    WHERE kelas='$kelas' AND hari='$hari'
    ORDER BY jam_mulai ASC
");

if(mysqli_num_rows($q)){
while($d=mysqli_fetch_assoc($q)){
?>
<tr>
    <td><?= $no++ ?></td>
    <td>
        <i class="bi bi-clock text-primary"></i><br>
        <small><?= $d['jam_mulai'].' - '.$d['jam_selesai'] ?></small>
    </td>
    <td>
        <span class="badge bg-primary badge-mapel">
            <i class="bi bi-book"></i> <?= $d['mapel'] ?>
        </span>
    </td>
    <td>
        <i class="bi bi-person-badge"></i><br>
        <small><?= $d['guru'] ?></small>
    </td>
    <td>
        <i class="bi bi-door-open"></i><br>
        <small><?= $d['ruang'] ?></small>
    </td>
</tr>
<?php }} else { ?>
<tr>
    <td colspan="5" class="text-muted py-4">
        <i class="bi bi-calendar-x fs-3"></i><br>
        Tidak ada jadwal hari <?= $hari ?>
    </td>
</tr>
<?php } ?>

</tbody>
</table>
</div>

</div>
<?php endforeach; ?>

</div>
<?php endif; ?>

</div>
</div>

<script src="../bootstrap-5.3.8-dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
