<?php
session_start();
include '../koneksi.php';

if (!isset($_SESSION['id']) || $_SESSION['role'] != 'siswa') {
    header("Location: ../login.php");
    exit;
}

$user_id = $_SESSION['id'];

$hari_indonesia = [
    'Sunday' => 'Minggu',
    'Monday' => 'Senin',
    'Tuesday' => 'Selasa',
    'Wednesday' => 'Rabu',
    'Thursday' => 'Kamis',
    'Friday' => 'Jumat',
    'Saturday' => 'Sabtu'
];

$query = mysqli_query(
    $koneksi,
    "SELECT * FROM absensi WHERE user_id='$user_id' ORDER BY tanggal DESC"
);
?>

<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Log Absen | MAYABSEN</title>

<link href="../bootstrap-5.3.8-dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600;700&display=swap" rel="stylesheet">

<style>
body{
    background:#f4f8f6;
    font-family:'Poppins',sans-serif;
}

/* BACK ARROW */
.back-arrow{
    position:fixed;
    top:18px;
    left:18px;
    font-size:1.6rem;
    color:#1b4332;
    text-decoration:none;
    z-index:20;
}

/* WRAPPER */
.page-wrapper{
    width:92%;
    margin:70px auto 30px;
}

/* HEADER */
.page-title{
    font-weight:700;
    color:#1b4332;
}

/* TIMELINE */
.timeline{
    position:relative;
    margin-left:10px;
}
.timeline::before{
    content:'';
    position:absolute;
    left:6px;
    top:0;
    bottom:0;
    width:4px;
    background:#d8f3dc;
    border-radius:10px;
}

.timeline-item{
    position:relative;
    margin-bottom:26px;
    padding-left:40px;
}

.timeline-dot{
    position:absolute;
    left:-2px;
    top:26px;
    width:16px;
    height:16px;
    background:#52b788;
    border-radius:50%;
    border:4px solid #fff;
    box-shadow:0 0 0 3px #d8f3dc;
}

/* CARD */
.absen-card{
    border:none;
    border-radius:20px;
    padding:18px 20px;
    box-shadow:0 12px 30px rgba(0,0,0,.10);
}

/* BADGE */
.badge-masuk{
    background:#b7e4c7;
    color:#1b4332;
    font-size:.75rem;
}
.badge-pulang{
    background:#bee1e6;
    color:#023047;
    font-size:.75rem;
}

/* RESPONSIVE */
@media (min-width:992px){
    .page-wrapper{
        max-width:900px;
    }
}
</style>
</head>

<body>

<!-- BACK -->
<a href="dashboard.php" class="back-arrow">
    <i class="bi bi-arrow-left"></i>
</a>

<div class="page-wrapper">

<!-- HEADER -->
<div class="text-center mb-4">
    <h4 class="page-title mb-1">
        <i class="bi bi-calendar-check-fill"></i>
        Riwayat Absensi
    </h4>
    <p class="text-muted mb-0">
        Catatan kehadiranmu yang membanggakan 🌱
    </p>
</div>

<?php if (mysqli_num_rows($query) == 0): ?>
    <div class="alert alert-light text-center shadow-sm rounded-4">
        <i class="bi bi-emoji-frown fs-3"></i><br>
        Belum ada riwayat absensi
    </div>
<?php else: ?>

<div class="timeline">

<?php while ($row = mysqli_fetch_assoc($query)):
    $hari = $hari_indonesia[date('l', strtotime($row['tanggal']))];
    $tgl  = date("d M Y", strtotime($row['tanggal']));
?>

<div class="timeline-item">
    <div class="timeline-dot"></div>

    <!-- ABSEN MASUK -->
    <?php if (!empty($row['jam_masuk'])): ?>
    <div class="card absen-card mb-3">
        <div class="d-flex justify-content-between align-items-center">
            <div>
                <span class="badge badge-masuk rounded-pill px-3 py-2">
                    <i class="bi bi-box-arrow-in-right"></i> Absen Masuk
                </span>
                <h6 class="mt-2 mb-1 fw-bold"><?= $hari ?>, <?= $tgl ?></h6>
                <small class="text-muted">
                    Jam Masuk: <b><?= $row['jam_masuk'] ?></b>
                </small>
            </div>
            <i class="bi bi-check-circle-fill text-success fs-3"></i>
        </div>
    </div>
    <?php endif; ?>

    <!-- ABSEN PULANG -->
    <?php if (!empty($row['jam_pulang'])): ?>
    <div class="card absen-card">
        <div class="d-flex justify-content-between align-items-center">
            <div>
                <span class="badge badge-pulang rounded-pill px-3 py-2">
                    <i class="bi bi-door-open-fill"></i> Absen Pulang
                </span>
                <h6 class="mt-2 mb-1 fw-bold"><?= $hari ?>, <?= $tgl ?></h6>
                <small class="text-muted">
                    Jam Pulang: <b><?= $row['jam_pulang'] ?></b>
                </small>
            </div>
            <i class="bi bi-emoji-smile-fill text-primary fs-3"></i>
        </div>
    </div>
    <?php endif; ?>

</div>

<?php endwhile; ?>

</div>
<?php endif; ?>

</div>

<script src="../bootstrap-5.3.8-dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
