<?php
session_start();
include '../koneksi.php';

if (!isset($_SESSION['id']) || $_SESSION['role'] != 'siswa') {
    header("Location: ../login.php");
    exit;
}

$user_id = $_SESSION['id'];
$query = mysqli_query($koneksi, "SELECT * FROM siswa WHERE user_id='$user_id'");
$siswa = mysqli_fetch_assoc($query);

if (!$siswa) {
    echo "Data siswa tidak ditemukan.";
    exit;
}

$foto = "../assets/default-profile.png";
if (!empty($siswa['foto']) && file_exists("../uploads/".$siswa['foto'])) {
    $foto = "../uploads/" . htmlspecialchars($siswa['foto']);
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Profil Siswa | MAYABSEN</title>

<link href="../bootstrap-5.3.8-dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">

<!-- FONT MODERN -->
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600;700&family=Montserrat:wght@600;700&display=swap" rel="stylesheet">

<style>
body{
    background:#f4f8f6;
    font-family:'Poppins',sans-serif;
    min-height:100vh;
}

/* TOP SECTION */
.profile-top{
    text-align:center;
    padding:35px 16px 20px;
    position:relative;
}

.profile-photo{
    width:150px;
    height:150px;
    border-radius:50%;
    object-fit:cover;
    box-shadow:0 10px 28px rgba(0,0,0,.25);
}

.profile-name{
    margin-top:14px;
    font-weight:700;
}

.profile-class{
    font-size:.85rem;
}

/* BACK BUTTON */
.btn-back{
    position:absolute;
    top:20px;
    left:20px;
    
    border:none;
    width:42px;
    height:42px;
    border-radius:50%;
    
}


/* CARD */
.card-profil{
    width:92%;
    margin:10px auto 25px;
    background:#fff;
    border-radius:22px;
    padding:22px;
    box-shadow:0 10px 30px rgba(0,0,0,.08);
}

/* ROW DATA */
.data-row{
    display:flex;
    justify-content:space-between;
    align-items:center;
    padding:10px 0;
    border-bottom:1px dashed #e0e0e0;
    font-size:14px;
}
.data-row:last-child{
    border-bottom:none;
}

.data-label{
    color:#777;
}

.data-value{
    font-weight:600;
    text-align:right;
}

/* SECTION TITLE */
.section-title{
    font-family:'Montserrat',sans-serif;
    font-weight:700;
    font-size:.9rem;
    letter-spacing:.6px;
    margin:18px 0 8px;
    color:#2e8b57;
}

/* BADGE */
.badge-custom{
    background:#e6f4f1;
    color:#2e8b57;
    font-weight:600;
    font-size:.75rem;
}

/* BUTTON */
.btn-edit{
    margin-top:20px;
    padding:10px;
    font-weight:600;
}
</style>
</head>

<body>

<div class="profile-top">
    <a href="dashboard.php" class="btn btn-back">
        <i class="bi bi-arrow-left"></i>
    </a>

    <img src="<?= $foto ?>" class="profile-photo" alt="Profil">
    <h5 class="profile-name"><?= htmlspecialchars($siswa['nama_lengkap']) ?></h5>
    <span class="badge badge-custom"><?= htmlspecialchars($siswa['kelas']) ?></span>
</div>

<div class="card-profil">

    <div class="section-title">INFORMASI SISWA</div>

    <div class="data-row">
        <span class="data-label">NISN</span>
        <span class="data-value"><?= $siswa['nisn'] ?></span>
    </div>
    <div class="data-row">
        <span class="data-label">Tempat Lahir</span>
        <span class="data-value"><?= $siswa['tempat_lahir'] ?></span>
    </div>
    <div class="data-row">
        <span class="data-label">Tanggal Lahir</span>
        <span class="data-value"><?= date('d F Y', strtotime($siswa['tanggal_lahir'])) ?></span>
    </div>
    <div class="data-row">
        <span class="data-label">Alamat</span>
        <span class="data-value"><?= $siswa['alamat'] ?></span>
    </div>
    <div class="data-row">
        <span class="data-label">No. WhatsApp</span>
        <span class="data-value"><?= $siswa['no_wa'] ?></span>
    </div>
    <div class="data-row">
        <span class="data-label">Email</span>
        <span class="data-value"><?= $siswa['email'] ?></span>
    </div>

    <div class="section-title">DATA ORANG TUA</div>

    <div class="data-row">
        <span class="data-label">Nama Ayah</span>
        <span class="data-value"><?= $siswa['nama_ayah'] ?></span>
    </div>
    <div class="data-row">
        <span class="data-label">Nama Ibu</span>
        <span class="data-value"><?= $siswa['nama_ibu'] ?></span>
    </div>

    <a href="edit_data_diri.php" class="btn btn-success w-100 rounded-pill btn-edit">
        <i class="bi bi-pencil-square me-1"></i> Edit Profil
    </a>
</div>

<script src="../bootstrap-5.3.8-dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
